/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA2Utils {
    public static final String PKCS1_PRIVATE_KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PKCS1_PRIVATE_KEY_FOOTER = "-----END RSA PRIVATE KEY-----";
    public static final String PKCS8_PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    public static final String PKCS8_PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    public static final String PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final int KEY_SIZE = 2048;
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final Logger log = LoggerFactory.getLogger(RSA2Utils.class);

    public static String sign(Map<String, Object> paramMap, String privateKey) {
        try {
            String signSource = RSA2Utils.getSignSource(paramMap);
            log.info("\u5f85\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)signSource);
            PrivateKey priKey = RSA2Utils.loadPrivateKeyFromPemContent(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM, PROVIDER);
            signature.initSign(priKey);
            signature.update(signSource.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException("RSA2\u7b7e\u540d\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static boolean verify(Map<String, Object> paramMap, String publicKey, String sign) {
        try {
            TreeMap<String, Object> copyMap = new TreeMap<String, Object>(paramMap);
            copyMap.remove("sign");
            String signSource = RSA2Utils.getSignSource(copyMap);
            System.out.println("\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32\uff1a" + signSource);
            PublicKey pubKey = RSA2Utils.loadPublicKeyFromPemContent(publicKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM, PROVIDER);
            signature.initVerify(pubKey);
            signature.update(signSource.getBytes(StandardCharsets.UTF_8));
            return signature.verify(Base64.getDecoder().decode(sign));
        }
        catch (Exception e) {
            throw new RuntimeException("RSA2\u9a8c\u7b7e\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private static PrivateKey loadPrivateKeyFromPemContent(String pemContent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        pemContent = pemContent.replace(PKCS1_PRIVATE_KEY_HEADER, "").replace(PKCS1_PRIVATE_KEY_FOOTER, "").replace(PKCS8_PRIVATE_KEY_HEADER, "").replace(PKCS8_PRIVATE_KEY_FOOTER, "").replaceAll("\\s", "");
        byte[] decodedKey = Base64.getDecoder().decode(pemContent);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePrivate(keySpec);
    }

    private static PublicKey loadPublicKeyFromPemContent(String pemContent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        pemContent = pemContent.replace(PUBLIC_KEY_HEADER, "").replace(PUBLIC_KEY_FOOTER, "").replaceAll("\\s", "");
        byte[] decodedKey = Base64.getDecoder().decode(pemContent);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePublic(keySpec);
    }

    private static String getSignSource(Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            return "";
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(paramMap);
        ArrayList paramList = new ArrayList();
        sortedMap.forEach((key, value) -> {
            if (StrUtil.equalsIgnoreCase((CharSequence)"sign", (CharSequence)key) || value == null || StrUtil.isEmpty((CharSequence)value.toString())) {
                return;
            }
            paramList.add(key + "=" + value);
        });
        return CollUtil.join(paramList, (CharSequence)"&");
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

