/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;

public class KeyGen {
    private static final String PRI_KEY_PATH = "private_key.pem";
    private static final String PUB_KEY_PATH = "public_key.pem";

    public static void main(String[] args) throws Exception {
        int keySize = 2048;
        if (args.length != 0) {
            keySize = Integer.parseInt(args[0]);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String privateKeyPem = KeyGen.toPemFormat(privateKey.getEncoded(), true, true);
        KeyGen.saveToFile(PRI_KEY_PATH, privateKeyPem);
        System.out.println("\u79c1\u94a5(PKCS#8)\u5df2\u4fdd\u5b58\u5230private_key.pem");
        String publicKeyPem = KeyGen.toPemFormat(publicKey.getEncoded(), false, false);
        KeyGen.saveToFile(PUB_KEY_PATH, publicKeyPem);
        System.out.println("\u516c\u94a5\u5df2\u4fdd\u5b58\u5230public_key.pem");
    }

    private static String toPemFormat(byte[] keyBytes, boolean isPrivate, boolean isPkcs8) {
        StringBuilder pemBuilder = new StringBuilder();
        if (isPrivate) {
            if (isPkcs8) {
                pemBuilder.append("-----BEGIN PRIVATE KEY-----").append("\n");
            } else {
                pemBuilder.append("-----BEGIN RSA PRIVATE KEY-----").append("\n");
            }
        } else {
            pemBuilder.append("-----BEGIN PUBLIC KEY-----").append("\n");
        }
        String encodedKey = Base64.getMimeEncoder(64, "\n".getBytes()).encodeToString(keyBytes);
        pemBuilder.append(encodedKey).append("\n");
        if (isPrivate) {
            if (isPkcs8) {
                pemBuilder.append("-----END PRIVATE KEY-----").append("\n");
            } else {
                pemBuilder.append("-----END RSA PRIVATE KEY-----").append("\n");
            }
        } else {
            pemBuilder.append("-----END PUBLIC KEY-----").append("\n");
        }
        return pemBuilder.toString();
    }

    private static void saveToFile(String filename, String content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            fos.write(content.getBytes());
        }
    }
}

