/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay.net;

import com.hexbit.hexpay.exception.APIConnectionException;
import com.hexbit.hexpay.net.APIHexpayRequest;
import com.hexbit.hexpay.net.APIHexpayResponse;
import com.hexbit.hexpay.net.APIResource;
import com.hexbit.hexpay.net.HttpClient;
import com.hexbit.hexpay.net.HttpHeaders;
import com.hexbit.hexpay.util.StreamUtils;
import com.hexbit.hexpay.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public APIHexpayResponse request(APIHexpayRequest request) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            conn = HttpURLConnectionClient.createHexpayConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            String responseBody = responseCode >= 200 && responseCode < 300 ? StreamUtils.readToEnd(conn.getInputStream(), APIResource.CHARSET) : StreamUtils.readToEnd(conn.getErrorStream(), APIResource.CHARSET);
            APIHexpayResponse aPIHexpayResponse = new APIHexpayResponse(responseCode, responseBody, headers);
            return aPIHexpayResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("\u8bf7\u6c42 HexPay(%s)\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u91cd\u8bd5.\u5f02\u5e38\u4fe1\u606f:%s", request.getUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    static HttpHeaders getHeaders(APIHexpayRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", Collections.singletonList(HttpURLConnectionClient.buildUserAgentString(request.getOptions().getVersion())));
        userAgentHeadersMap.put("X-Hexpay-Client-User-Agent", Collections.singletonList(HttpURLConnectionClient.buildXHexpayClientUserAgentString(request.getOptions().getVersion())));
        return request.getHeaders().withAdditionalHeaders(userAgentHeadersMap);
    }

    private static HttpURLConnection createHexpayConnection(APIHexpayRequest request) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)request.url.openConnection();
        conn.setConnectTimeout(request.options.getConnectTimeout());
        conn.setReadTimeout(request.options.getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), StringUtils.join(",", entry.getValue()));
        }
        conn.setRequestMethod(request.method.name());
        if (request.content != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.content.contentType);
            try (OutputStream output = conn.getOutputStream();){
                output.write(request.content.byteArrayContent);
            }
        }
        return conn;
    }
}

