/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay.net;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.hexbit.hexpay.exception.APIException;
import com.hexbit.hexpay.exception.HexpayException;
import com.hexbit.hexpay.exception.InvalidRequestException;
import com.hexbit.hexpay.net.APIHexpayRequest;
import com.hexbit.hexpay.net.APIHexpayResponse;
import com.hexbit.hexpay.net.HttpClient;
import com.hexbit.hexpay.net.HttpURLConnectionClient;
import com.hexbit.hexpay.request.HexpayRequest;
import com.hexbit.hexpay.response.HexpayResponse;
import com.hexbit.hexpay.util.JSONWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIResource {
    private static final Logger _log = LoggerFactory.getLogger(APIResource.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static HttpClient httpClient = new HttpURLConnectionClient();

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public <T extends HexpayResponse> T execute(HexpayRequest<T> request, RequestMethod method, String url) throws HexpayException {
        String jsonParam = new JSONWriter().write(request.getBizModel(), true);
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        _log.debug("JSONObject={}", (Object)params);
        request.getRequestOptions();
        APIHexpayRequest apiHexpayRequest = new APIHexpayRequest(method, url, (Map<String, Object>)params, request.getRequestOptions());
        if (_log.isDebugEnabled()) {
            _log.debug("Hexpay_SDK_REQ\uff1aurl={}, data={}", (Object)apiHexpayRequest.getUrl(), (Object)JSONObject.toJSONString(apiHexpayRequest.getParams(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        APIHexpayResponse response = httpClient.requestWithRetries(apiHexpayRequest);
        int responseCode = response.getResponseCode();
        String responseBody = response.getResponseBody();
        if (_log.isDebugEnabled()) {
            _log.debug("Hexpay_SDK_RES\uff1acode={}, body={}", (Object)responseCode, (Object)responseBody);
        }
        if (responseCode != 200) {
            APIResource.handleAPIError(response);
        }
        HexpayResponse resource = null;
        try {
            resource = (HexpayResponse)JSONObject.parseObject((String)responseBody, request.getResponseClass());
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(responseBody, responseCode);
        }
        return (T)resource;
    }

    private static void handleAPIError(APIHexpayResponse response) throws HexpayException {
        String rBody = response.getResponseBody();
        int rCode = response.getResponseCode();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parseObject((String)rBody);
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(rBody, rCode);
        }
        if (rCode == 404) {
            throw new InvalidRequestException(jsonObject.getString("status") + ", " + jsonObject.getString("error") + ", " + jsonObject.getString("path"), rCode, null);
        }
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode) throws APIException {
        throw new APIException(String.format("Invalid response object from API: %s. (HTTP response code was %d)", responseBody, responseCode), null, null, responseCode, null);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

