/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay.net;

import com.hexbit.hexpay.exception.APIConnectionException;
import com.hexbit.hexpay.exception.HexpayException;
import com.hexbit.hexpay.net.APIResource;
import com.hexbit.hexpay.net.HttpContent;
import com.hexbit.hexpay.net.HttpHeaders;
import com.hexbit.hexpay.net.RequestOptions;
import com.hexbit.hexpay.util.HexpayKit;
import com.hexbit.hexpay.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APIHexpayRequest {
    APIResource.RequestMethod method;
    URL url;
    HttpContent content;
    HttpHeaders headers;
    Map<String, Object> params;
    RequestOptions options;

    public APIHexpayRequest(APIResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws HexpayException {
        try {
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options;
            this.method = method;
            this.url = APIHexpayRequest.buildURL(method, StringUtils.genUrl(url, this.options.getUri()), params);
            this.content = APIHexpayRequest.buildContent(method, params, this.options);
            this.headers = APIHexpayRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("\u8bf7\u6c42 HexPay(%s)\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u91cd\u8bd5.\u5f02\u5e38\u4fe1\u606f:%s", StringUtils.genUrl(url, options.getUri()), e.getMessage()), e);
        }
    }

    private static URL buildURL(APIResource.RequestMethod method, String spec, Map<String, Object> params) throws IOException {
        String queryString;
        StringBuilder sb = new StringBuilder();
        sb.append(spec);
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT && params != null && !(queryString = APIHexpayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        return new URL(sb.toString());
    }

    public static URL buildURLWithSign(String url, Map<String, Object> params, RequestOptions options) throws APIConnectionException {
        String queryString;
        String signature;
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIHexpayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        try {
            signature = APIHexpayRequest.buildHexpaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210Hexpay\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.genUrl(url, options.getUri()));
        if (params != null && !(queryString = APIHexpayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        try {
            return new URL(sb.toString());
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210 Hexpay \u8bf7\u6c42URL\u5f02\u5e38", e);
        }
    }

    private static HttpContent buildContent(APIResource.RequestMethod method, Map<String, Object> params, RequestOptions options) throws HexpayException {
        String signature;
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT) {
            return null;
        }
        if (params == null) {
            return null;
        }
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIHexpayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        try {
            signature = APIHexpayRequest.buildHexpaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210Hexpay\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        return HttpContent.buildJSONContent(params);
    }

    private static String createQuery(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Map<String, String> flatParams = APIHexpayRequest.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIHexpayRequest.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String urlEncodePair(String k, String v) {
        return String.format("%s=%s", APIHexpayRequest.urlEncode(k), APIHexpayRequest.urlEncode(v));
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) continue;
            if (value instanceof Map) {
                APIHexpayRequest.handleNestedMap(key, (Map)value, flatParams);
                continue;
            }
            if (value instanceof List) {
                APIHexpayRequest.handleNestedList(key, (List)value, flatParams);
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static void handleNestedMap(String parentKey, Map<?, ?> nestedMap, Map<String, String> flatParams) {
        for (Map.Entry<?, ?> nestedEntry : nestedMap.entrySet()) {
            String childKey = String.format("%s[%s]", parentKey, nestedEntry.getKey() != null ? nestedEntry.getKey().toString() : "null");
            Object childValue = nestedEntry.getValue();
            if (childValue instanceof Map) {
                APIHexpayRequest.handleNestedMap(childKey, (Map)childValue, flatParams);
                continue;
            }
            if (childValue instanceof List) {
                APIHexpayRequest.handleNestedList(childKey, (List)childValue, flatParams);
                continue;
            }
            if (childValue == null) {
                flatParams.put(childKey, "");
                continue;
            }
            flatParams.put(childKey, childValue.toString());
        }
    }

    private static void handleNestedList(String parentKey, List<?> nestedList, Map<String, String> flatParams) {
        for (int i = 0; i < nestedList.size(); ++i) {
            String childKey = String.format("%s[%d]", parentKey, i);
            Object childValue = nestedList.get(i);
            if (childValue instanceof Map) {
                APIHexpayRequest.handleNestedMap(childKey, (Map)childValue, flatParams);
                continue;
            }
            if (childValue instanceof List) {
                APIHexpayRequest.handleNestedList(childKey, (List)childValue, flatParams);
                continue;
            }
            if (childValue == null) {
                flatParams.put(childKey, "");
                continue;
            }
            flatParams.put(childKey, childValue.toString());
        }
    }

    private static HttpHeaders buildHeaders(APIResource.RequestMethod method, RequestOptions options) throws HexpayException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Collections.singletonList("application/json"));
        headerMap.put("Accept-Charset", Collections.singletonList(APIResource.CHARSET.name()));
        headerMap.put("Accept-Language", Collections.singletonList(options.getAcceptLanguage()));
        return HttpHeaders.of(headerMap);
    }

    protected static String buildHexpaySignature(Map<String, Object> params, RequestOptions options) throws IOException {
        String signType = options.getSignType();
        if ("MD5".equalsIgnoreCase(signType)) {
            return HexpayKit.getSign(params, options.getApiKey());
        }
        if ("RSA2".equalsIgnoreCase(signType)) {
            return HexpayKit.getRsaSign(params, options.getApiKey());
        }
        throw new AssertionError((Object)"\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u7c7b\u578b");
    }

    protected static String currentTimeString() {
        return String.valueOf(System.currentTimeMillis());
    }

    public APIResource.RequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public RequestOptions getOptions() {
        return this.options;
    }
}

