/*
 * Decompiled with CFR 0.152.
 */
package com.hexbit.hexpay;

import com.alibaba.fastjson2.JSONObject;
import com.hexbit.hexpay.Hexpay;
import com.hexbit.hexpay.exception.HexpayException;
import com.hexbit.hexpay.net.APIHexpayRequest;
import com.hexbit.hexpay.net.APIResource;
import com.hexbit.hexpay.net.RequestOptions;
import com.hexbit.hexpay.request.HexpayRequest;
import com.hexbit.hexpay.response.HexpayResponse;
import com.hexbit.hexpay.util.JSONWriter;
import java.util.HashMap;
import java.util.Map;

public class HexpayClient
extends APIResource {
    private static final Map<String, HexpayClient> clientMap = new HashMap<String, HexpayClient>();
    private String appId;
    private String signType = "RSA2";
    private String apiKey = Hexpay.apiKey;
    private String apiBase = Hexpay.getApiBase();

    public HexpayClient(String apiBase, String signType, String apiKey) {
        this.apiBase = apiBase;
        this.signType = signType;
        this.apiKey = apiKey;
    }

    public HexpayClient(String apiBase, String apiKey) {
        this.apiBase = apiBase;
        this.apiKey = apiKey;
    }

    public HexpayClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public HexpayClient() {
    }

    public static synchronized HexpayClient getInstance(String appId, String apiKey, String apiBase) {
        HexpayClient client = clientMap.get(appId);
        if (client != null) {
            return client;
        }
        client = new HexpayClient();
        clientMap.put(appId, client);
        client.appId = appId;
        client.apiKey = apiKey;
        client.apiBase = apiBase;
        return client;
    }

    public static synchronized HexpayClient getInstance(String appId, String apiKey, String apiBase, String signType) {
        HexpayClient client = clientMap.get(appId);
        if (client != null) {
            return client;
        }
        client = new HexpayClient();
        clientMap.put(appId, client);
        client.appId = appId;
        client.apiKey = apiKey;
        client.apiBase = apiBase;
        client.signType = signType;
        return client;
    }

    public static synchronized HexpayClient getInstance(String appId, String apiKey) {
        HexpayClient client = clientMap.get(appId);
        if (client != null) {
            return client;
        }
        client = new HexpayClient();
        clientMap.put(appId, client);
        client.appId = appId;
        client.apiKey = apiKey;
        return client;
    }

    public static synchronized HexpayClient getInstance(String appId) {
        HexpayClient client = clientMap.get(appId);
        if (client != null) {
            return client;
        }
        client = new HexpayClient();
        clientMap.put(appId, client);
        client.appId = appId;
        return client;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }

    public <T extends HexpayResponse> T execute(HexpayRequest<T> request) throws HexpayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setAppId(this.appId).setApiKey(this.apiKey).setSignType(this.signType).build();
            request.setRequestOptions(options);
        }
        return this.execute(request, APIResource.RequestMethod.POST, this.apiBase);
    }

    public String getRequestUrl(HexpayRequest request) throws HexpayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setAppId(this.appId).setApiKey(this.apiKey).build();
            request.setRequestOptions(options);
        }
        String jsonParam = new JSONWriter().write(request.getBizModel(), true);
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        request.getRequestOptions();
        System.out.println("HexpayClient#params:" + params);
        return APIHexpayRequest.buildURLWithSign(this.apiBase, (Map<String, Object>)params, request.getRequestOptions()).toString();
    }
}

